<?php 
session_start();
include 'db.php';
include 'config.php';

$err = "";
$wrn = "";
$msg = "";

$email = $password = "";

if (isset($_POST['submit'])) {
    if (empty($_POST["email"])) {
        $wrn = "Email is required";
    } else {
        $email = test_input($_POST["email"]);
    }

    if (empty($_POST["password"])) {
        $err = "Password is required";
    } else {
        $password = test_input($_POST["password"]);
    }

    if ($email == "" || $password == "") {
        $err = "Email or Password fields cannot be empty!";
    } else {
        $sql = mysqli_query($link, "SELECT id, email, password, username FROM users WHERE email ='$email' AND password= '$password'");
        if (mysqli_num_rows($sql) > 0) {
            $data = mysqli_fetch_assoc($sql);
            $_SESSION['email'] = $data['email'];
            $_SESSION['id'] = $data['id'];
            $username = $data['username'];

            mysqli_query($link, "UPDATE users SET last_access = NOW() WHERE email = '$email' ");
            $msg = "Login was successful";
            echo "<meta http-equiv='refresh' Content='4; url=dashboard/' />";
        } else {
            $err = "Invalid Email and Password";
        }
    }
}

function test_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}
?>

<!DOCTYPE html>
<html lang="en-US">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>Login - Vertesquests</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .bg-gradient-custom {
            background:rgb(234 179 8 / var(--tw-bg-opacity, 1));
            background-size: 200% 200%;
            animation: gradientBG 10s ease infinite;
        }
        
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .input-icon-wrapper {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            left: 15px;
            color: #6b7280;
        } 
        
        .input-with-icon {
            padding-left: 45px !important;
        }
        
        .hover-lift {
            transition: transform 0.3s ease;
        }
        
        .hover-lift:hover {
            transform: translateY(-3px);
        }
    </style>
</head>
<body class="bg-gray-100 text-gray-800 min-h-screen flex flex-col">

    <div class="absolute w-full h-64 bg-gradient-custom"></div>

    <header class="relative z-10 pt-6 pb-2 text-white">
        <div class="container mx-auto flex items-center justify-between px-4">
            <div class="flex items-center">
                <div class="bg-white text-gray-600 rounded-full p-2 mr-3 shadow-md">
                    
                </div>
                <h1 class="text-3xl font-bold tracking-tight">LOGIN</h1>
            </div>
            <nav class="hidden md:block">
                
            </nav>
            <div class="block md:hidden">
                <button class="text-white p-2">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>
    </header>

    <main class="flex-grow container mx-auto py-10 px-4 relative z-10 mt-8">
        <div class="max-w-md mx-auto bg-white rounded-xl shadow-lg overflow-hidden transform hover-lift transition-all duration-300">
            <div class="bg-gradient-custom p-8 text-white text-center">
                <div class="bg-white/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-circle text-3xl"></i>
                </div>
                <h2 class="text-2xl font-bold mb-1">Member Login</h2>
                <p class="text-gray-100 opacity-90">Access your account dashboard</p>
            </div>

            <form method="post" action="signin.php" class="p-8">
                <!-- Error messages -->
                <?php if(!empty($err)): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r-md shadow-sm flex items-center" role="alert">
                    <i class="fas fa-exclamation-circle mr-3 text-red-500"></i>
                    <p><?php echo $err; ?></p>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($wrn)): ?>
                <div class="bg-[#fbbf24]-100 border-l-4 border-yellow-500 text-yellow-700 p-4 mb-6 rounded-r-md shadow-sm flex items-center" role="alert">
                    <i class="fas fa-exclamation-triangle mr-3 text-yellow-500"></i>
                    <p><?php echo $wrn; ?></p>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($msg)): ?>
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-r-md shadow-sm flex items-center" role="alert">
                    <i class="fas fa-check-circle mr-3 text-green-500"></i>
                    <p><?php echo $msg; ?></p>
                </div>
                <?php endif; ?>

                <div class="mb-6">
                    <label for="email" class="block text-gray-700 font-medium mb-2">Email Address</label>
                    <div class="input-icon-wrapper">
                        <i class="fas fa-envelope input-icon"></i>
                        <input type="email" id="email" name="email" placeholder="your@email.com" required 
                            class="input-with-icon w-full px-4 py-3 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-600 focus:border-transparent transition duration-200">
                    </div>
                </div>

                <div class="mb-6">
                    <div class="flex items-center justify-between mb-2">
                        <label for="password" class="block text-gray-700 font-medium">Password</label>
                        <a href="forgot-password.php" class="text-sm text-gray-600 hover:text-gray-800 transition duration-200">Forgot Password?</a>
                    </div>
                    <div class="input-icon-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" id="password" name="password" placeholder="Your password" required 
                            class="input-with-icon w-full px-4 py-3 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-600 focus:border-transparent transition duration-200">
                    </div>
                </div>

                <div class="flex items-center mb-6">
                    <input type="checkbox" id="remember" name="remember" class="h-4 w-4 text-gray-600 focus:ring-gray-500 border-gray-300 rounded">
                    <label for="remember" class="ml-2 block text-sm text-gray-700">Remember me</label>
                </div>

                <button name="submit" type="submit" class="w-full bg-gradient-custom hover:opacity-90 text-white font-bold py-3 rounded-lg transition duration-300 shadow-md flex items-center justify-center">
                    <i class="fas fa-sign-in-alt mr-2"></i>
                    Sign In
                </button>

               
              
                <p class="mt-8 text-center">
                    Not a member yet? <a href="register.php" class="text-gray-600 hover:text-gray-800 font-medium hover:underline transition duration-200">Register Now</a>
                </p>
            </form>
        </div>
    </main>

  

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        // Show sweet alert on successful login
        <?php if(!empty($msg)): ?>
        $(document).ready(function() {
            swal({
                title: "Success!",
                text: "<?php echo $msg; ?>",
                icon: "success",
                button: "Continue",
            });
        });
        <?php endif; ?>
        
        // Toggle password visibility
        $(document).ready(function() {
            // Add password toggle eye icon
            $('.input-icon-wrapper:has(#password)').append('<i class="fas fa-eye absolute right-4 top-1/2 transform -translate-y-1/2 text-gray-500 cursor-pointer password-toggle"></i>');
            
            // Toggle password visibility
            $('.password-toggle').on('click', function() {
                const passwordInput = $('#password');
                const icon = $(this);
                
                if (passwordInput.attr('type') === 'password') {
                    passwordInput.attr('type', 'text');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    passwordInput.attr('type', 'password');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });
        });
    </script>
</body>
</html>