document.addEventListener('DOMContentLoaded', function () {
    const burger = document.querySelector('.burger');
    const nav = document.querySelector('nav');

    burger.addEventListener('click', () => {
      burger.classList.toggle('active');
      nav.classList.toggle('active');
    });

    
            // Получаем все элементы списка
            var items = document.querySelectorAll('.get_started_item');

            // Устанавливаем индекс текущего элемента
            var currentIndex = 0;
    
            // Функция для изменения классов и переключения между элементами
            function switchItem() {
                // Удаляем класс current_item у текущего элемента
                items[currentIndex].classList.remove('current_item');
    
                // Увеличиваем индекс текущего элемента
                currentIndex = (currentIndex + 1) % items.length;
    
                // Добавляем класс current_item к новому текущему элементу
                items[currentIndex].classList.add('current_item');
            }
    
            // Устанавливаем интервал для вызова функции каждые 10 секунд
            setInterval(switchItem, 10000);



    const depCoin = document.getElementById('cryptoDropdown');
    const selectedCrypto = document.getElementById('selectedCrypto');
    const cryptoList = document.getElementById('cryptoList');

    depCoin.addEventListener('click', function (event) {
        if (event.target.closest('.selectedCrypto')) {
            cryptoList.style.display = cryptoList.style.display === 'none' ? 'block' : 'none';
        }
    });

    cryptoList.addEventListener('click', function (event) {
        const cryptoItem = event.target.closest('div[data-crypto]');
        if (cryptoItem) {
            const selectedCryptoSymbol = cryptoItem.dataset.crypto;
            const selectedCryptoName = cryptoItem.querySelector('p').innerText;
            const selectedCryptoLogo = cryptoItem.querySelector('img').src;

            selectedCrypto.innerHTML = `<img src="${selectedCryptoLogo}" alt="${selectedCryptoSymbol}">${selectedCryptoSymbol}`;

            cryptoList.style.display = 'none';
        }
    });

    // Close the dropdown if the user clicks outside of it
    window.addEventListener('click', function (event) {
        if (!depCoin.contains(event.target) && !cryptoList.contains(event.target)) {
            cryptoList.style.display = 'none';
        }
    });

    

});

