<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>BTC Deposit</title>
  <!-- Tailwind CSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Google Fonts - Inter -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet" />
  <!-- Google Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <style>
    body {
      font-family: 'Inter', sans-serif;
      background: #000000;
      color: #d1d5db; /* Tailwind gray-300 */
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      margin: 0;
    }
    button:focus-visible {
      outline: 2px solid #fbbf24; /* Tailwind amber-400 */
      outline-offset: 2px;
    }
    button {
      transition: background-color 0.3s ease, box-shadow 0.3s ease;
    }
    /* Smooth scroll for input text when clicked */
    input:focus {
      scroll-behavior: smooth;
    }
  </style>
</head>
<body class="flex flex-col min-h-screen">
  <header class="bg-gray-900 shadow sticky top-0 z-30">
    <div class="max-w-4xl mx-auto px-8 py-5 flex items-center gap-3">
      <img src="https://bitcoin.org/img/icons/logotop.svg?1749679667" alt="Bitcoin Logo" class="w-8 h-8 flex-shrink-0" />
      <h1 class="text-2xl font-semibold text-white">BTC Deposit</h1>
    </div>
    <p class="max-w-4xl mx-auto px-8 pb-4 text-gray-400 text-sm">Deposit Bitcoin (BTC) to your wallet address below</p>
  </header>

  <main class="flex flex-grow justify-center items-center px-6 py-12">
    <section class="bg-gray-900 shadow-xl rounded-3xl max-w-3xl w-full p-10 flex flex-col md:flex-row items-center gap-10">
      <!-- BTC Logo only -->
      <div class="flex-shrink-0 w-28 h-28 md:w-36 md:h-36 rounded-full flex items-center justify-center bg-amber-400 shadow-lg">
        <img src="https://bitcoin.org/img/icons/logotop.svg?1749679667" alt="Bitcoin Logo" class="w-20 h-20" />
      </div>

      <!-- Address and actions -->
      <div class="flex flex-col flex-grow space-y-8 text-gray-200">
        <label for="btcAddress" class="font-semibold text-lg select-none">Your BTC Wallet Address</label>
        <div class="relative">
          <input id="btcAddress" type="text" readonly
                 value="GET FROM LIVE-SUPPORT"
                 class="w-full rounded-lg border border-gray-700 bg-gray-800 px-5 py-4 text-yellow-400 text-sm font-mono pr-16 focus:outline-none focus:ring-2 focus:ring-amber-400 focus:border-amber-400"
                 aria-describedby="copyHint" />
         
        </div>
        <p id="copyHint" class="text-xs text-gray-400">Click "Copy" to copy the address to clipboard.</p>

        <p class="text-sm text-gray-400 leading-relaxed">
          Send Bitcoin only to this address. Deposits in other cryptocurrencies may be lost.<br />
          Confirmations on the blockchain may take a few minutes.
        </p>
      </div>
    </section>
  </main>

  <footer class="bg-gray-900 text-center text-gray-500 text-xs py-5 border-t border-gray-800">
    &copy; 2025 . All rights reserved.
  </footer>

  <script>
    const copyBtn = document.getElementById('copyBtn');
    const btcAddressInput = document.getElementById('btcAddress');

    copyBtn.addEventListener('click', async () => {
      try {
        await navigator.clipboard.writeText(btcAddressInput.value);
        copyBtn.innerHTML = '<span class="material-icons text-base select-none">check_circle</span>Copied';
        copyBtn.disabled = true;
        setTimeout(() => {
          copyBtn.innerHTML = '<span class="material-icons text-base select-none">content_copy</span>Copy';
          copyBtn.disabled = false;
        }, 2000);
      } catch (err) {
        alert('Failed to copy address. Please copy manually.');
      }
    });
  </script>
</body>
</html>

