<?php 
include 'header.php';
?>

<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta content="width=device-width, initial-scale=1" name="viewport"/>
  <title>DashBoard</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap');
    body {
      font-family: 'Inter', sans-serif;
    }
  </style>
</head>
<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '52f386042b30a215a27ddb89084b825d50b2705c';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
<body class="bg-[#0a0a0a] text-white min-h-screen flex flex-col">

 <br> <br> <br>
  <!-- Main Content -->
  <main class="px-5 flex-grow">
    <div class="flex justify-between items-center mb-5">
      <h1 class="text-white text-lg font-semibold tracking-wide">My Dashboard</h1>
      <button aria-label="User  profile and settings" class="text-white text-xl">
        <i class="fas fa-user-friends"></i>
      </button>
    </div>

    <div class="mb-1 flex items-center space-x-2">
      <span class="text-gray-400 text-xs font-normal">Total Assets</span>
      <button aria-label="Toggle visibility" class="text-gray-400 text-xs">
        <i class="fas fa-eye"></i>
      </button>
    </div>

    <div class="flex items-center space-x-2">
      <span class="text-white font-extrabold text-3xl leading-none">

  <?php echo $currencySymbol . number_format($mbalance + $dbalance, 2); ?>


      </span>
      <button class="flex items-center space-x-1 text-white text-sm font-semibold">
        <span></span>
        <i class="fas fa-chevron-down text-xs"></i>
      </button>
      <div class="flex-1 h-1 rounded-l-md bg-gradient-to-r from-[#b37f0a] to-[#3a1a00]"></div>
    </div>

    <div class="text-gray-400 text-xs mt-1 flex items-center space-x-1">
      <span>≈ <?php echo number_format($mbalance / 50000, 8); ?> BTC</span>
      <button aria-label="More info" class="text-gray-400 text-xs">
        <i class="fas fa-info-circle"></i>
      </button>
    </div>

    <!-- Action Buttons -->
    <center> <div class="mt-5 grid grid-cols-4 gap-3">
 <a href="deposit.php" class="bg-[#1a1a1a] rounded-lg flex flex-col items-center justify-center col-span-2 h-20 space-y-3 text-xs text-white font-semibold">

    <i class="fas fa-wallet text-xl text-[#fbbf24]"></i>
    <span>Deposit</span>
  </a>
  <a href="withdraw.php" class="bg-[#1a1a1a] rounded-lg flex flex-col items-center justify-center col-span-2 py-3 space-y-3  text-xs text-white font-semibold">
    <i class="fas fa-upload text-xl text-[#fbbf24]"></i>
    <span>Withdraw</span>
  </a>
 
</div></center>
  


    <!-- Account Items -->
    <div class="mt-4 space-y-3">
      <div class="bg-[#1a1a1a] rounded-lg px-4 py-3 flex justify-between items-center">
        <div>
          <p class="text-gray-400 text-xs">Profit</p><br>
          <p class="text-white font-semibold text-lg leading-none">
            <?php echo $currencySymbol . number_format($mbalance, 2); ?>
            <span class="text-xs font-normal"></span>
          </p>
        </div>
        <button aria-label="Go to Funding details" class="text-gray-400 text-lg">
          
        </button>
      </div>
      <div class="bg-[#1a1a1a] rounded-lg px-4 py-3 flex justify-between items-center">
        <div>
          <p class="text-gray-400 text-xs">Deposit</p><br>
          <p class="text-white font-semibold text-lg leading-none">
           <?php echo $currencySymbol ?><?php echo number_format($dbalance) ?>
            <span class="text-xs font-normal"></span>
          </p>
        </div>
        
        <button aria-label="Go to Unified Trading details" class="text-gray-400 text-lg">
          
        </button>
      </div>
       <div class="mt-4 space-y-3">
      <div class="bg-[#1a1a1a] rounded-lg px-4 py-3 flex justify-between items-center">
        <div>
          <p class="text-gray-400 text-xs">Bonus</p><br>
          <p class="text-white font-semibold text-lg leading-none">
           <?php echo $currencySymbol ?><?php echo number_format($abonus) ?>
            <span class="text-xs font-normal"></span>
          </p>
        </div>
        <button aria-label="Go to Funding details" class="text-gray-400 text-lg">
          
        </button>
      </div>
    </div>
    
  </main>
  <br>
  <center>
<div class="trading">
    <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="#" rel="noopener nofollow" ><span class="blue-text">AI trading chart</span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
  {
  "width": "350",
  "height": "410",
  "symbol": "NASDAQ:AAPL",
  "interval": "D",
  "timezone": "Etc/UTC",
  "theme": "dark",
  "style": "1",
  "locale": "en",
  "hide_top_toolbar": true,
  "hide_legend": true,
  "allow_symbol_change": false,
  "save_image": false,
  "hide_volume": true,
  "support_host": "https://www.tradingview.com"
}
  </script>
</div>
<!-- TradingView Widget END -->
    
</div>
<center>
  <!-- Bottom Navigation -->
  <nav class="bg-[#0a0a0a] border-t border-gray-800 flex justify-around items-center py-2 text-xs text-gray-400 font-normal">
    <button class="flex flex-col items-center space-y-1">
      <i class="fas fa-home text-lg"></i>
      <span>Home</span>
    </button>
    <button class="flex flex-col items-center space-y-1">
      <i class="fas fa-chart-bar text-lg"></i>
      <span>Markets</span>
    </button>
    <button class="flex flex-col items-center space-y-1">
      <i class="fas fa-file-alt text-lg"></i>
      <span>Trade</span>
    </button>
    <button class="flex flex-col items-center space-y-1">
      <i class="fas fa-coins text-lg"></i>
      <span>Earn</span>
    </button>
    <button class="flex flex-col items-center space-y-1 text-[#fbbf24]">
      <i class="fas fa-wallet text-lg"></i>
      <span>Assets</span>
    </button>
  </nav>

