<?php
include 'db.php';
include 'config.php';

$fname = $username = $email = $password = $phone = $dob = $currency = $accounttype = $btcwallet = $plan = "";
$err = "";
$suc = "";
$wrn = "";

session_start();


$ref_user = isset($_GET['ref']) ? strtolower($_GET['ref']) : "";

if (isset($_POST['submit'])) {
    if (empty(test_input($_POST["name"]))) {
        $wrn = "Please enter first name.";
    } else {
        $fname = test_input($_POST["name"]);
    }

    if (empty(test_input($_POST["phone"]))) {
        $wrn = "Please enter Phone number.";
    } else {
        $phone = test_input($_POST["mergedPhone"]); // Use the merged phone number
    }

    if (empty(test_input($_POST["currency"]))) {
        $wrn = "Please select currency.";
    } else {
        $currency = test_input($_POST["currency"]);
    }

    if (empty(test_input($_POST["username"]))) {
        $wrn = "Please enter a username.";
    } else {
        // Prepare a select statement
        $sql = "SELECT id FROM users WHERE username = ?";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "s", $param_username);
            $param_username = trim($_POST["username"]);
            if (mysqli_stmt_execute($stmt)) {
                mysqli_stmt_store_result($stmt);
                if (mysqli_stmt_num_rows($stmt) == 1) {
                    $err = "This username is already taken.";
                } else {
                    $username = test_input($_POST["username"]);
                    $username = ucwords($username);
                }
            } else {
                $err = "Oops! Something went wrong. Please try again later.";
            }
        }
        mysqli_stmt_close($stmt);
    }

    if (empty(test_input($_POST["email"]))) {
        $wrn = "Please enter an email.";
    } else {
        // Prepare a select statement
        $sql = "SELECT id FROM users WHERE email = ?";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "s", $param_email);
            $param_email = trim($_POST["email"]);
            if (mysqli_stmt_execute($stmt)) {
                mysqli_stmt_store_result($stmt);
                if (mysqli_stmt_num_rows($stmt) == 1) {
                    $err = "This email is already taken.";
                } else {
                    $email = test_input($_POST["email"]);
                }
            } else {
                $err = "Oops! Something went wrong. Please try again later.";
            }
        }
        mysqli_stmt_close($stmt);
    }

    if (empty(test_input($_POST["password"]))) {
        $wrn = "Please enter a password.";
    } elseif (strlen(test_input($_POST["password"])) < 6) {
        $wrn = "Password must have at least 6 characters.";
    } else {
        $password = test_input($_POST["password"]);
    }

    if (empty(test_input($_POST["password2"]))) {
        $wrn = "Please confirm password.";
    } elseif ($password != test_input($_POST['password2'])) {
        $err = "Passwords do not match";
    }

    if (empty(test_input($_POST['security']))) {
        $wrn = "Please enter security answer";
    } elseif (test_input($_POST['security']) != '34') { // Replace '34' with the actual answer
        $err = "Your security answer is not correct!";
    }

    // CSRF Token Validation
    if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $err = "Invalid CSRF token.";
    }

    if (empty($err) && empty($wrn)) {
        $refuser = test_input($_POST['ref']);
        // Store password in plain text (not recommended)
        $query = "INSERT INTO users (fullname, username, email, password, phone, currency, referral) VALUES ('$fname','$username', '$email', '$password', '$phone', '$currency', '$refuser')";
        $save = mysqli_query($link, $query);

        if ($save) {
            mysqli_query($link, "UPDATE users SET refbalance = refbalance + $ref_bonus WHERE username = '$refuser' ");
            $suc = "Registration successful! Please check your email for further instructions.";
        } else {
            $err = "Sign Up was not successful, try again. Database error: " . mysqli_error($link);
        }

        if ($link) {
            mysqli_close($link);
        }
    }
}

function test_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}
?>

<!DOCTYPE html>
<html lang="en-US">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>Registration - Crypto Investment Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css">
</head>
   <script src="https://cdn.tailwindcss.com"></script>
<body class="bg-gray-50 text-gray-800 min-h-screen flex flex-col">

    <header class="bg-yellow-400 text-white p-6">
        <div class="container mx-auto flex items-center justify-between">
            <h1 class="text-3xl font-bold">REGISTER</h1>
            <nav class="hidden md:block">
                <ul class="flex space-x-6">
                    <li><a href="index.php" class="hover:text-blue-800 transition">Home</a></li>
                    <li><a href="about.php" class="hover:text-blue-800 transition">About</a></li>
                    <li><a href="plans.php" class="hover:text-blue-300 transition">Investment Plans</a></li>
                    <li><a href="contact.php" class="hover:text-blue-300 transition">Contact</a></li>
                    <li><a href="signin.php" class="bg-blue-600 hover:bg-blue-700 px-4 py-2 rounded-lg transition">Sign In</a></li>
                </ul>
            </nav>
            <button class="md:hidden text-white focus:outline-none">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
        </div>
    </header>

    <main class="flex-grow container mx-auto py-10 px-4">
        <div class="max-w-lg mx-auto">
            <div class="bg-white rounded-2xl shadow-sm overflow-hidden border border-gray-100">
                <!-- Header -->
                <div class="bg-yellow-500 p-8 text-white text-center">
                    <h2 class="text-2xl font-semibold mb-2">Create Account</h2>
                    <p class="text-yellow-100 text-sm">Join our community</p>
                    
                    <!-- Progress Steps -->
                    <div class="flex items-center justify-center mt-8 space-x-4">
                        <div class="flex flex-col items-center">
                            <div id="step1-indicator" class="w-6 h-6 rounded-full bg-white text-yellow-500 flex items-center justify-center text-sm font-medium">1</div>
                            <span class="text-xs mt-2 text-yellow-100">Account</span>
                        </div>
                        <div class="h-px w-8 bg-yellow-300"></div>
                        <div class="flex flex-col items-center">
                            <div id="step2-indicator" class="w-6 h-6 rounded-full bg-yellow-300 text-yellow-500 flex items-center justify-center text-sm font-medium">2</div>
                            <span class="text-xs mt-2 text-yellow-100">Details</span>
                        </div>
                        <div class="h-px w-8 bg-yellow-300"></div>
                        <div class="flex flex-col items-center">
                            <div id="step3-indicator" class="w-6 h-6 rounded-full bg-yellow-300 text-yellow-500 flex items-center justify-center text-sm font-medium">3</div>
                            <span class="text-xs mt-2 text-yellow-100">Verify</span>
                        </div>
                    </div>
                </div>

                <!-- Form Container -->
                <form method="post" action="register.php" class="p-8">
                    <!-- Step 1: Account Information -->
                    <div id="step1" class="step active">
                        <div class="space-y-6">
                            <div>
                                <label for="email" class="block text-gray-700 text-sm font-medium mb-2">Email</label>
                                <input type="email" id="email" name="email" placeholder="your@email.com" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div>
                                <label for="username" class="block text-gray-700 text-sm font-medium mb-2">Username</label>
                                <input type="text" id="username" name="username" placeholder="Choose username" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div>
                                <label for="password" class="block text-gray-700 text-sm font-medium mb-2">Password</label>
                                <input type="password" id="password" name="password" placeholder="Create password" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div>
                                <label for="password2" class="block text-gray-700 text-sm font-medium mb-2">Confirm Password</label>
                                <input type="password" id="password2" name="password2" placeholder="Repeat password" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                        </div>
                        
                        <div class="mt-8">
                            <button type="button" id="nextToStep2" class="w-full bg-yellow-500 hover:bg-yellow-600 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                                Continue
                            </button>
                        </div>
                    </div>

                    <!-- Step 2: Personal Details -->
                    <div id="step2" class="step hidden">
                        <div class="space-y-6">
                            <div>
                                <label for="name" class="block text-gray-700 text-sm font-medium mb-2">Full Name</label>
                                <input type="text" id="name" name="name" placeholder="Enter full name" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div>
                                <label for="phone" class="block text-gray-700 text-sm font-medium mb-2">Phone Number</label>
                                <input type="tel" id="phone" name="phone" placeholder="Phone number" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div>
                                <label for="currency" class="block text-gray-700 text-sm font-medium mb-2">Currency</label>
                                <select id="currency" name="currency" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none appearance-none bg-white">
                                    <option value="" disabled selected>Select currency</option>
                                    <option value="USD">US Dollar (USD)</option>
                                    <option value="EUR">Euro (EUR)</option>
                                    <option value="GBP">British Pound (GBP)</option>
                                    <option value="INR">Indian Rupee (INR)</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="flex gap-3 mt-8">
                            <button type="button" id="backToStep1" class="flex-1 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium py-3 px-4 rounded-lg transition-colors">
                                Back
                            </button>
                            <button type="button" id="nextToStep3" class="flex-1 bg-yellow-500 hover:bg-yellow-600 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                                Continue
                            </button>
                        </div>
                    </div>

                    <!-- Step 3: Verification -->
                    <div id="step3" class="step hidden">
                        <div class="space-y-6">
                            <div>
                                <label for="security" class="block text-gray-700 text-sm font-medium mb-2">5 × 5 + 9 = ?</label>
                                <input type="text" id="security" name="security" placeholder="Answer" required 
                                    class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 transition-all outline-none">
                            </div>
                            
                            <div class="flex items-start gap-3">
                                <input id="agree" name="agree" type="checkbox" required
                                    class="mt-1 w-4 h-4 border border-gray-300 rounded bg-white focus:ring-2 focus:ring-yellow-100">
                                <label for="agree" class="text-sm text-gray-600">
                                    I agree to the <a href="rules.php" class="text-yellow-500 hover:text-yellow-600">Terms</a> and <a href="privacy.php" class="text-yellow-500 hover:text-yellow-600">Privacy Policy</a>
                                </label>
                            </div>
                        </div>
                        
                        <div class="flex gap-3 mt-8">
                            <button type="button" id="backToStep2" class="flex-1 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium py-3 px-4 rounded-lg transition-colors">
                                Back
                            </button>
                            <button type="submit" name="submit" class="flex-1 bg-yellow-500 hover:bg-yellow-600 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                                Create Account
                            </button>
                        </div>
                    </div>
                </form>
                
                <!-- Bottom -->
                <div class="bg-gray-50 p-6 text-center border-t border-gray-100">
                    <p class="text-gray-500 text-sm">Already have an account? <a href="signin.php" class="text-yellow-500 hover:text-yellow-600 font-medium">Sign In</a></p>
                </div>
            </div>
        </div>
    </main>

  

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        $(document).ready(function () {
            // Initialize telephone input
            const phoneInputField = document.querySelector("#phone");
            const mergedPhoneInput = document.querySelector("#mergedPhone");

            const phoneInput = window.intlTelInput(phoneInputField, {
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                preferredCountries: ["us", "gb", "ca", "au"],
                separateDialCode: true
            });

            // Update merged phone when input changes
            phoneInputField.addEventListener("input", function () {
                const selectedCountryData = phoneInput.getSelectedCountryData();
                const phoneNumber = phoneInputField.value;
                const mergedPhoneNumber = `+${selectedCountryData.dialCode}${phoneNumber}`;
                mergedPhoneInput.value = mergedPhoneNumber;
            });

            // Password visibility toggle
            $("#togglePassword").on("click", function() {
                const passwordField = document.getElementById("password");
                const type = passwordField.getAttribute("type") === "password" ? "text" : "password";
                passwordField.setAttribute("type", type);
                // Toggle icon (optional)
            });

            $("#togglePassword2").on("click", function() {
                const passwordField = document.getElementById("password2");
                const type = passwordField.getAttribute("type") === "password" ? "text" : "password";
                passwordField.setAttribute("type", type);
                // Toggle icon (optional)
            });

            // Password strength meter
            $("#password").on("input", function() {
                const password = $(this).val();
                let strength = 0;
                
                if (password.length >= 6) strength += 25;
                if (password.match(/[A-Z]/)) strength += 25;
                if (password.match(/[0-9]/)) strength += 25;
                if (password.match(/[^A-Za-z0-9]/)) strength += 25;
                
                $("#password-strength").css("width", strength + "%");
                
                if (strength <= 25) {
                    $("#password-strength").removeClass().addClass("bg-red-500 h-1.5 rounded-full");
                    $("#password-feedback").text("Weak password").removeClass().addClass("text-xs text-red-500");
                } else if (strength <= 50) {
                    $("#password-strength").removeClass().addClass("bg-yellow-500 h-1.5 rounded-full");
                    $("#password-feedback").text("Medium password").removeClass().addClass("text-xs text-yellow-600");
                } else if (strength <= 75) {
                    $("#password-strength").removeClass().addClass("bg-blue-500 h-1.5 rounded-full");
                    $("#password-feedback").text("Strong password").removeClass().addClass("text-xs text-blue-600");
                } else {
                    $("#password-strength").removeClass().addClass("bg-green-500 h-1.5 rounded-full");
                    $("#password-feedback").text("Very strong password").removeClass().addClass("text-xs text-green-600");
                }
            });

            // Password matching check
            $("#password2").on("input", function() {
                const password = $("#password").val();
                const confirmPassword = $(this).val();
                
                if (password === confirmPassword) {
                    $("#match-feedback").text("Passwords match").removeClass().addClass("text-xs text-green-600 mt-1");
                } else {
                    $("#match-feedback").text("Passwords do not match").removeClass().addClass("text-xs text-red-500 mt-1");
                }
            });

            // Multi-step form navigation
            $("#nextToStep2").on("click", function() {
                const email = $("#email").val();
                const username = $("#username").val();
                const password = $("#password").val();
                const password2 = $("#password2").val();
                
                let isValid = true;
                
                if (!email) {
                    isValid = false;
                    $("#email").addClass("border-red-500");
                } else {
                    $("#email").removeClass("border-red-500");
                }
                
                if (!username) {
                    isValid = false;
                    $("#username").addClass("border-red-500");
                } else {
                    $("#username").removeClass("border-red-500");
                }
                
                if (!password || password.length < 6) {
                    isValid = false;
                    $("#password").addClass("border-red-500");
                } else {
                    $("#password").removeClass("border-red-500");
                }
                
                if (!password2 || password !== password2) {
                    isValid = false;
                    $("#password2").addClass("border-red-500");
                } else {
                    $("#password2").removeClass("border-red-500");
                }
                
                if (isValid) {
                    $("#step1").removeClass("active").addClass("hidden");
                    $("#step2").removeClass("hidden").addClass("active");
                    $("#step1-indicator").removeClass("bg-white").addClass("bg-blue-500 text-white");
                    $("#step2-indicator").removeClass("bg-blue-200").addClass("bg-white text-blue-600");
                }
            });

            $("#backToStep1").on("click", function() {
                $("#step2").removeClass("active").addClass("hidden");
                $("#step1").removeClass("hidden").addClass("active");
                $("#step1-indicator").removeClass("bg-blue-500 text-white").addClass("bg-white");
                $("#step2-indicator").removeClass("bg-white text-blue-600").addClass("bg-blue-200");
            });

            $("#nextToStep3").on("click", function() {
                const name = $("#name").val();
                const phone = $("#phone").val();
                const currency = $("#currency").val();
                
                let isValid = true;
                
                if (!name) {
                    isValid = false;
                    $("#name").addClass("border-red-500");
                } else {
                    $("#name").removeClass("border-red-500");
                }
                
                if (!phone) {
                    isValid = false;
                    $("#phone").addClass("border-red-500");
                } else {
                    $("#phone").removeClass("border-red-500");
                }
                
                if (!currency) {
                    isValid = false;
                    $("#currency").addClass("border-red-500");
                } else {
                    $("#currency").removeClass("border-red-500");
                }
                
                if (isValid) {
                    $("#step2").removeClass("active").addClass("hidden");
                    $("#step3").removeClass("hidden").addClass("active");
                    $("#step2-indicator").removeClass("bg-white").addClass("bg-blue-500 text-white");
                    $("#step3-indicator").removeClass("bg-blue-200").addClass("bg-white text-blue-600");
                }
            });

            $("#backToStep2").on("click", function() {
                $("#step3").removeClass("active").addClass("hidden");
                $("#step2").removeClass("hidden").addClass("active");
                $("#step2-indicator").removeClass("bg-blue-500 text-white").addClass("bg-white text-blue-600");
                $("#step3-indicator").removeClass("bg-white text-blue-600").addClass("bg-blue-200");
            });
        });
    </script>
    
    <!-- Chat Support Script -->
    <script src="//code.tidio.co/lcvfvk32el2agiqsjdv2azg7os43tjzg.js" async></script>
</body>
</html>